﻿<%@ Import Namespace="Soneta.CRM" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.SrodkiTrwale" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Handel" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Towary" %>
<%@ Import Namespace="Soneta.Magazyny" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>

<%@ Page Language="c#" AutoEventWireup="false" CodePage="1200" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title>Towar</title>
    <meta content="C#" name="CODE_LANGUAGE">
    <meta content="JavaScript" name="vs_defaultClientScript">
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">

    <script runat="server">

        public class ParametryContext : ContextBase
        {
            public ParametryContext(Context cx)
                : base(cx)
            {
            }

            private int krotność = 1;

            [Priority(10)]
            public int Krotność
            {
                get { return krotność; }
                set
                {
                    krotność = value;
                    OnChanged(EventArgs.Empty);
                }
            }

            [Context(Required = false)]
            public Magazyn Magazyn { get; set; }

        }

        ParametryContext parametry;

        [Context]
        public ParametryContext Parametry {
            get { return parametry; }
            set { parametry = value; }
        }
        

        public class TotalS : IComparable {
            readonly ElementKompletu elementKompletu;
            DoubleCy wartosc = DoubleCy.Zero;
            Quantity ilosc = Quantity.Zero;
            Quantity brak = Quantity.Zero;
            DoubleCy wartoscBraku = DoubleCy.Zero;
            public TotalS(ElementKompletu elementKompletu, ParametryContext parametry) {
                this.elementKompletu = elementKompletu;
                ilosc = elementKompletu.Towar.PrzeliczJednostkę(elementKompletu.Towar.Jednostka, elementKompletu.Ilosc, true) * parametry.Krotność;
                wartosc = elementKompletu.WartoscWCZakupu * parametry.Krotność;
                Towar t = elementKompletu.Towar;
                Magazyn mag = elementKompletu.Magazyn == null ? parametry.Magazyn : elementKompletu.Magazyn;
                if (t.Typ != TypTowaru.Usługa) {
                    Quantity sumaIlosci = Quantity.Zero;
                    foreach (Zasob z in t.Zasoby)
                        if(z.GetObjectRight() != AccessRights.Denied && ((mag != null && z.Magazyn == mag) || mag == null))
                            if ((z.Partia.Typ == TypPartii.Magazynowy || z.Partia.Typ == TypPartii.Zamówiony) && !z.Zamkniety)
                                sumaIlosci += z.Ilosc;
                    brak = sumaIlosci - ilosc > Quantity.Zero ? Quantity.Zero : sumaIlosci - ilosc;
                    brak = brak < Quantity.Zero ? -brak : brak;
                    wartoscBraku = elementKompletu.Towar.OstatniaCenaZakupu.Netto * brak.Value;                    
                    //wartosc = brak == Quantity.Zero ? wartosc : DoubleCy.Zero;
                }
       
            }
            public ElementKompletu ElementKompletu {
                get { return elementKompletu; }
            }
            public DoubleCy Wartosc {
                get {
                    return wartosc;
                }
            }
                                  
            public Quantity Ilosc {
                get {
                    return ilosc;
                }
            }
            public string Brak {
                get {
                    if (elementKompletu.Towar.Typ == TypTowaru.Usługa)
                        return "nie dotyczy"; 
                    return brak.ToString();
                }
            }
            /* TID: 13504;
            public string WartoscBraku {
                get {
                    if (elementKompletu.Towar.Typ == TypTowaru.Usługa)
                        return "nie dotyczy"; 
                    return wartoscBraku.ToString();
                }
            }*/
            public DoubleCy WartoscBraku {
                get {
                    if (elementKompletu.Towar.Typ == TypTowaru.Usługa)
                        return DoubleCy.Zero;
                    return wartoscBraku;
                }
            }            
            public int CompareTo(object obj) {
                TotalS t = (TotalS)obj;
                return ElementKompletu.Towar.Nazwa.CompareTo(t.ElementKompletu.Towar.Nazwa);
            }
        }

        public class TotalP : IComparable {
            readonly ElementKompletu elementKompletu;
            readonly int krotność;
            readonly Quantity ilość;
            public TotalP(ElementKompletu elementKompletu, int krotność) {
                this.elementKompletu = elementKompletu;
                this.krotność = krotność;
                this.ilość = elementKompletu.Ilosc * krotność;
            }
            public ElementKompletu ElementKompletu {
                get { return elementKompletu; }
            }
            public Quantity Ilosc {
                get { return ilość; }
            }
            public int CompareTo(object obj) {
                TotalP t = (TotalP)obj;
                return ElementKompletu.Towar.Nazwa.CompareTo(t.ElementKompletu.Towar.Nazwa);
            }
        }

        protected void dc_ContextLoad(object sender, EventArgs e) {
            ReportHeader.Title += string.Format("|Na dzień: {0}", Date.Now.ToString("yyyy-MM-dd"));
            ReportHeader.Title += string.Format("|Krotność: {0}", Parametry.Krotność.ToString());
        
            if (parametry.Magazyn != null)
                ReportHeader.Title += String.Format("|Magazyn: {0}", Parametry.Magazyn.ToString());

            Towar[] rows = (Towar[])dc[typeof(Towar[])];
            Hashtable resultP = new Hashtable();
            Hashtable resultS = new Hashtable();
            foreach (Towar towar in rows)
            {
                System.Diagnostics.Trace.WriteLine(Environment.NewLine + "TRACE:" + towar);
                if (towar.Typ == TypTowaru.Towar || towar.Typ == TypTowaru.Usługa) continue;
                foreach (ElementKompletu elementKompletu in towar.ElementyKompletu) {
                    if (elementKompletu.Typ == TypElementuKompletu.Produkt) {
                        TotalP tp = (TotalP)resultP[elementKompletu];
                        if (tp == null) {
                            tp = new TotalP(elementKompletu, Parametry.Krotność);
                            resultP.Add(tp.ElementKompletu, tp);
                        }
                    }
                    if (elementKompletu.Typ == TypElementuKompletu.Składnik) {
                        TotalS ts = (TotalS)resultS[elementKompletu];
                        if (ts == null) {
                            ts = new TotalS(elementKompletu, Parametry);
                            resultS.Add(ts.ElementKompletu, ts);
                        }
                    }
                }
            }
            ArrayList listaP = new ArrayList(resultP.Values);
            listaP.Sort();
            GridP.DataSource = listaP;
            
            ArrayList listaS = new ArrayList(resultS.Values);
            listaS.Sort();
            GridS.DataSource = listaS;
        }

    </script>

</head>
<body>
    <form method="post" runat="server" id="form">
        <ea:DataContext ID="dc" runat="server" TypeName="Soneta.Towary.Towar,Soneta.Handel"
            OnContextLoad="dc_ContextLoad"></ea:DataContext>
        <eb:ReportHeader ID="ReportHeader" runat="server" Title="Zapotrzebowanie i koszt kompletacji|Towar: {0}"
            DataMember0="."></eb:ReportHeader>
        <div style="font-weight: bold; font-size: 8pt; width: 100%; border-bottom: thin solid;
            font-family: Verdana">
            Produkty
        </div>
        <ea:Grid runat="server" ID="GridP" RowTypeName="Soneta.Towary.ElementKompletu,Soneta.Handel">
            <Columns>
                <ea:GridColumn ID="GridColumn1" Width="4" Align="Right" DataMember="#" Caption="Lp." runat="server" EncodeHTML="True">
                </ea:GridColumn>
                <ea:GridColumn ID="GridColumn2" Align="Left" DataMember="ElementKompletu.Towar" Caption="Towar" runat="server" EncodeHTML="True">
                </ea:GridColumn>
                <ea:GridColumn ID="GridColumn3" Width="18" Align="Left" DataMember="Ilosc" Caption="Ilość" runat="server" EncodeHTML="True">
                </ea:GridColumn>
            </Columns>
        </ea:Grid>
        <br />
        <div style="font-weight: bold; font-size: 8pt; width: 100%; border-bottom: thin solid;
            font-family: Verdana">
            Składniki
        </div>
        <ea:Grid runat="server" ID="GridS" RowTypeName="Soneta.Towary.ElementKompletu,Soneta.Handel">
            <Columns>
                <ea:GridColumn ID="GridColumn4" Width="4" Align="Right" DataMember="#" Caption="Lp." runat="server" EncodeHTML="True">
                </ea:GridColumn>
                <ea:GridColumn ID="GridColumn5" Align="Left" DataMember="ElementKompletu.Towar" Caption="Towar" runat="server" EncodeHTML="True">
                </ea:GridColumn>
                <ea:GridColumn ID="GridColumn6" Width="18" Align="Left" DataMember="Ilosc" Caption="Ilość" runat="server" EncodeHTML="True">
                </ea:GridColumn>
                <ea:GridColumn ID="GridColumn7" Width="18" Align="Left" DataMember="Wartosc" Caption="Wartość" Total="Sum" runat="server" EncodeHTML="True">
                </ea:GridColumn>
                <ea:GridColumn ID="GridColumn8" Width="18" Align="Left" DataMember="Brak" Caption="Brak" runat="server" EncodeHTML="True">
                </ea:GridColumn>
                <ea:GridColumn ID="GridColumn9" Width="18" Align="Left" DataMember="WartoscBraku" Caption="Wartość braku" Total="Sum" runat="server" EncodeHTML="True">
                </ea:GridColumn>
            </Columns>
        </ea:Grid>
        <eb:ReportFooter ID="ReportFooter" runat="server" TheEnd="false">
        </eb:ReportFooter>
    </form>
</body>
</html>

